/*
 * All the function for frequency and amplitude setting for channel 1
 * */
#include <math.h>
#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include <string.h>
#include "inc/hw_memmap.h"
#include "inc/hw_gpio.h"
#include "inc/hw_nvic.h"
#include "inc/hw_sysctl.h"
#include "inc/hw_types.h"
#include "driverlib/fpu.h"
#include "driverlib/gpio.h"
#include "driverlib/flash.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/uart.h"
#include "driverlib/udma.h"
#include "driverlib/rom.h"
#include "grlib/grlib.h"
#include "grlib/widget.h"
#include "grlib/canvas.h"
#include "grlib/checkbox.h"
#include "grlib/container.h"
#include "grlib/pushbutton.h"
#include "grlib/radiobutton.h"
#include "grlib/slider.h"

#include "lcd_tools/Kentec320x240x16_ssd2119_spi.h"
#include "lcd_tools/touch.h"

#include "FreqAmpSelch2.h"
#include "InitializeFunctions.h"

//frequency and amplitude variable for channel 2
float freqCh2 = 2; // 1 - 5
float ampCh2 = 1; // 1 - 3
char ampStrCh2[15], freqStrCh2[15];

//All the button description for frequency - 2 setting
RectangularButton(freqCoarseIncButCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119,
                  160, 24, 65, 37, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0,
                  0, BUT_TEXT_COLOR, &g_sFontCm20, " + ", 0, 0, 0, 0,
                  freqCoarseIncButCh2Fun);
RectangularButton(freqCoarseDecButCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119,
                  240, 24, 65, 37, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0,
                  0, BUT_TEXT_COLOR, &g_sFontCm20, " - ", 0, 0, 0, 0,
                  freqCoarseDecButCh2Fun);
RectangularButton(freqFineIncButCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 160,
                  66, 65, 37, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0, 0,
                  BUT_TEXT_COLOR, &g_sFontCm20, " + ", 0, 0, 0, 0,
                  freqFineIncButCh2Fun);
RectangularButton(freqFineDecButCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 240,
                  66, 65, 37, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0, 0,
                  BUT_TEXT_COLOR, &g_sFontCm20, " - ", 0, 0, 0, 0,
                  freqFineDecButCh2Fun);

//All the button description for amplitude - 2 setting
RectangularButton(ampCoarseIncButCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119,
                  160, 108, 65, 37, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL,
                  0, 0, BUT_TEXT_COLOR, &g_sFontCm20, " + ", 0, 0, 0, 0,
                  ampCoarseIncButCh2Fun);
RectangularButton(ampCoarseDecButCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119,
                  240, 108, 65, 37, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL,
                  0, 0, BUT_TEXT_COLOR, &g_sFontCm20, " - ", 0, 0, 0, 0,
                  ampCoarseDecButCh2Fun);
RectangularButton(ampFineIncButCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 160,
                  150, 65, 37, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0, 0,
                  BUT_TEXT_COLOR, &g_sFontCm20, " + ", 0, 0, 0, 0,
                  ampFineIncButCh2Fun);
RectangularButton(ampFineDecButCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 240,
                  150, 65, 37, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0, 0,
                  BUT_TEXT_COLOR, &g_sFontCm20, " - ", 0, 0, 0, 0,
                  ampFineDecButCh2Fun);

//back and forth functionality buttons
RectangularButton(backButFASCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 0, 195,
                  90, 44, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, BUT_PRESS,
                  0, BUT_TEXT_COLOR, &g_sFontCm20, "BACK", 0, 0, 0, 0,
                  backButFASFuncCh2);
RectangularButton(nextButFASCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 230,
                  195, 90, 44, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL,
                  BUT_PRESS, 0, BUT_TEXT_COLOR, &g_sFontCm20, "NEXT", 0, 0, 0,
                  0, nextButFASFuncCh2);

// update function for frequncy both on screen and UART
void updateFreqCh2()
{
    printFreqStr(freqStrCh2, &freqCh2);
    makeRect(&freqRectCh2, 10, 49, 79, 79, RECT_FREQAMP_COLOR, freqStrCh2);
}

void updateAmpCh2()
{
    printAmpStr(ampStrCh2, &ampCh2);
    makeRect(&ampRectCh2, 10, 149, 79, 179, RECT_FREQAMP_COLOR, ampStrCh2);
}

// onclik functions for frequency change
void freqCoarseIncButCh2Fun(tWidget *psWidget)
{
    freqCh2 = freqCh2 + 5;
    updateFreqCh2();
}

void freqCoarseDecButCh2Fun(tWidget *psWidget)
{
    freqCh2 = freqCh2 - 5;
    if (freqCh2 <= 0)
    {
        freqCh2 = 1;
    }
    updateFreqCh2();
}

void freqFineIncButCh2Fun(tWidget *psWidget)
{
    freqCh2 = freqCh2 + 1;
    updateFreqCh2();
}

void freqFineDecButCh2Fun(tWidget *psWidget)
{
    freqCh2 = freqCh2 - 1;
    if (freqCh2 <= 0)
    {
        freqCh2 = 1;
    }
    updateFreqCh2();
}

// onclik functions for amplitude change
void ampCoarseIncButCh2Fun(tWidget *psWidget)
{
    ampCh2 = ampCh2 + 1;
    updateAmpCh2();
}

void ampCoarseDecButCh2Fun(tWidget *psWidget)
{
    ampCh2--;
    if (ampCh2 <= 0)
    {
        ampCh2 = 1;
    }
    updateAmpCh2();
}

void ampFineIncButCh2Fun(tWidget *psWidget)
{
    ampCh2 = ampCh2 + 0.1;
    updateAmpCh2();
}

void ampFineDecButCh2Fun(tWidget *psWidget)
{
    ampCh2 = ampCh2 - 0.1;
    if (ampCh2 <= 0)
    {
        ampCh2 = 1;
    }
    updateAmpCh2();
}

//onclick function for the Back button on freq&amp select - 2 screen
void backButFASFuncCh2(tWidget *psWidget)
{

    WidgetRemove((tWidget*) &freqCoarseIncButCh2);
    WidgetRemove((tWidget*) &freqCoarseDecButCh2);
    WidgetRemove((tWidget*) &freqFineIncButCh2);
    WidgetRemove((tWidget*) &freqFineDecButCh2);

    WidgetRemove((tWidget*) &ampCoarseIncButCh2);
    WidgetRemove((tWidget*) &ampCoarseDecButCh2);
    WidgetRemove((tWidget*) &ampFineIncButCh2);
    WidgetRemove((tWidget*) &ampFineDecButCh2);

    WidgetRemove((tWidget*) &backButFASCh2);
    WidgetRemove((tWidget*) &nextButFASCh2);

    clr_scrn_total();

    freqAmpSelScreenCh1();

}

//onclick function for the next button on freq&amp select - 2 screen
void nextButFASFuncCh2(tWidget *psWidget)
{
    WidgetRemove((tWidget*) &freqCoarseIncButCh2);
    WidgetRemove((tWidget*) &freqCoarseDecButCh2);
    WidgetRemove((tWidget*) &freqFineIncButCh2);
    WidgetRemove((tWidget*) &freqFineDecButCh2);

    WidgetRemove((tWidget*) &ampCoarseIncButCh2);
    WidgetRemove((tWidget*) &ampCoarseDecButCh2);
    WidgetRemove((tWidget*) &ampFineIncButCh2);
    WidgetRemove((tWidget*) &ampFineDecButCh2);

    WidgetRemove((tWidget*) &backButFASCh2);
    WidgetRemove((tWidget*) &nextButFASCh2);

    clr_scrn_total();

    displayWaveScreenCh1();
}

//onclick function for the next button on Freq and Amp select screen for channel 1(adding widgets to the screen)
void freqAmpSelScreenCh2()
{
    screenChar = 'c';

    clr_scrn_total();

    // for Freq
    WidgetAdd(WIDGET_ROOT, (tWidget*) &freqCoarseIncButCh2);
    WidgetPaint((tWidget* )&freqCoarseIncButCh2);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &freqCoarseDecButCh2);
    WidgetPaint((tWidget* )&freqCoarseDecButCh2);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &freqFineIncButCh2);
    WidgetPaint((tWidget* )&freqFineIncButCh2);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &freqFineDecButCh2);
    WidgetPaint((tWidget* )&freqFineDecButCh2);

    // for Amp

    WidgetAdd(WIDGET_ROOT, (tWidget*) &ampCoarseIncButCh2);
    WidgetPaint((tWidget* )&ampCoarseIncButCh2);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &ampCoarseDecButCh2);
    WidgetPaint((tWidget* )&ampCoarseDecButCh2);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &ampFineIncButCh2);
    WidgetPaint((tWidget* )&ampFineIncButCh2);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &ampFineDecButCh2);
    WidgetPaint((tWidget* )&ampFineDecButCh2);

    // for last line

    WidgetAdd(WIDGET_ROOT, (tWidget*) &backButFASCh2);
    WidgetPaint((tWidget* )&backButFASCh2);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &nextButFASCh2);
    WidgetPaint((tWidget* )&nextButFASCh2);

    makeRect(&FuncGenRect, 0, 0, 319, 19, RECT_FOREGROUND_COLOR,
             "FUNCTION GENERATOR");
    // add the calculation of freq
    updateFreqCh2();
    makeRect(&freqCoarseRectCh2, 90, 39, 150, 59, RECT_FOREGROUND_COLOR,
             "Coarse");
    makeRect(&freqFineRectCh2, 90, 79, 150, 99, RECT_FOREGROUND_COLOR, "Fine");
    //add the calcualtion for Amp
    updateAmpCh2();
    makeRect(&ampCoarseRectCh2, 90, 129, 150, 149, RECT_FOREGROUND_COLOR,
             "Coarse");
    makeRect(&ampFineRectCh2, 90, 169, 150, 189, RECT_FOREGROUND_COLOR, "Fine");
    makeRect(&freqAmpRectCh2, 90, 194, 229, 239, RECT_FOREGROUND_COLOR,
             "Freq & Amp Sel Ch2");
}
